<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    xpath-default-namespace="http://www.tei-c.org/ns/1.0"
    xmlns="http://www.w3.org/1999/xhtml"
    xmlns:hcmc="http://hcmc.uvic.ca/ns"
    exclude-result-prefixes="#all"
    version="2.0">
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Feb 1, 2016</xd:p>
            <xd:p><xd:b>Author:</xd:b> mholmes</xd:p>
            <xd:p>This is a simple XSLT module for rendering Gull's Hornbook chapters 
            to XHTML5 for students to view and proof their encoding.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xsl:param name="cssDir" select="'../css'"/>
    <xsl:output method="xhtml" encoding="UTF-8" normalization-form="NFC" omit-xml-declaration="yes"
        exclude-result-prefixes="#all" indent="yes"/>
    
    <xsl:variable name="root" select="/"/>
    
    <xsl:template match="/">
<!-- XHTML5 document.       -->
        <xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html>
</xsl:text>
        <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
            <head>
                <meta charset="utf-8" />
                <title><xsl:value-of select="TEI/teiHeader/fileDesc/titleStmt/title[1]"/></title>
<!-- We'll simply import the CSS directly from the CSS file.               -->
                <style type="text/css">
                    <xsl:comment>
                        <xsl:copy-of select="unparsed-text(concat($cssDir, '/guls_web.css'), 'UTF-8')"/>
                    </xsl:comment>
                </style>
            </head>
            <body>
                <div>
                    <xsl:apply-templates select="//text"/>
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="div | p | head | fw">
        <div>
            <xsl:sequence select="hcmc:processAttributes(.)"/>
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="choice[sic and corr]">
        <span class="choice" title="sic: {sic}"><xsl:apply-templates select="corr"/></span>
    </xsl:template>
    
    <xsl:template match="choice[abbr and expan]">
        <span class="choice" title="expansion: {expan}"><xsl:apply-templates select="abbr"/></span>
    </xsl:template>
    
    <xsl:template match="abbr | corr | hi | lb | pb | persName | placeName | orgName | seg">
        <span>
            <xsl:sequence select="hcmc:processAttributes(.)"/>
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    
    
    <xsl:function name="hcmc:processAttributes" as="attribute()*">
        <xsl:param name="srcEl" as="element()"/>
        <xsl:attribute name="data-el" select="local-name($srcEl)"/>
        <xsl:apply-templates select="$srcEl/@xml:id | $srcEl/@style | $srcEl/@type"/>
    </xsl:function>
    
    <xsl:template match="@xml:id">
        <xsl:attribute name="id" select="."/>
    </xsl:template>
    
    <xsl:template match="@style">
        <xsl:variable name="massagedStyle">
            <xsl:choose>
                <xsl:when test="contains(., 'font-style') and not(contains(., 'font-weight'))"><xsl:value-of select="concat(., ' font-weight: normal;')"/></xsl:when>
                <xsl:when test="contains(., 'font-weight') and not(contains(., 'font-style'))"><xsl:value-of select="concat(., ' font-style: normal;')"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:attribute name="style" select="$massagedStyle"/>
    </xsl:template>
    
    <xsl:template match="@type">
        <xsl:attribute name="data-type" select="."/>
    </xsl:template>
        
    
</xsl:stylesheet>